string GetDescription()
{
	return "This is an advanced piano arrangement. Currently implemented styles include:\n - Boogie-Woogie";
}

int ArrangeBoogieWoogie(Song @s)
{
	int bars = s.GetBars();
	
	s.AddTrack("Melody", RndInt(2,4),127,64);
	s.AddTrack("Alt Voice", RndInt(1,4),127,64);
	s.AddTrack("Accomp", RndInt(1,4),127,64);
	s.AddTrack("Chorus Intro", RndInt(1,4),127,64);
	
	string bw = "Boogie Woogie";
	if (RndInt(0,1) == 0) bw += " Swing";
		
	int bw_seed = RndInt(0,32000);
	int bw_seed_chorus = RndInt(0,32000);
	int bw_seed_alt = RndInt(0,32000);
	int chor_off = RndInt(0,1);
	int intro_seed = RndInt(0,32000);
	
	string melody = "Simple Melody";
	if (RndInt(0,2) == 0) melody = "Accented Melody";
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0)
		{
			s.AddRenderEvent("Simple Chords", RndInt(0,32000), 1,s.GetPartStartBar(i),s.GetPartEndBar(i), 1, CreateTime(0,0),0.8); 		
			s.AddRenderEvent(bw, bw_seed, 2,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, -1+RndInt(0,1), CreateTime(0,0),1.0); 
		}
		if (s.GetPart(i).GetArrHint() == 1)
		{
			s.AddRenderEvent(melody, RndInt(0,32000), 0,s.GetPartStartBar(i),s.GetPartEndBar(i), 1, CreateTime(0,0),1); 
			s.AddRenderEvent(bw, bw_seed, 2,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, -1, CreateTime(0,0),1.0); 
		}
		if (s.GetPart(i).GetArrHint() == 2)
		{
			s.AddRenderEvent(melody, RndInt(0,32000), 1,s.GetPartStartBar(i),s.GetPartEndBar(i), 1, CreateTime(0,0),1); 
			s.AddRenderEvent(bw, bw_seed_alt, 2,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, -1, CreateTime(0,0),1.0); 
		}
		if (s.GetPart(i).GetArrHint() == 3)
		{
			s.AddRenderEvent("Chordal Melody", RndInt(0,32000), 0,s.GetPartStartBar(i),s.GetPartEndBar(i), 2, CreateTime(0,0),1); 
			s.AddRenderEvent(bw, bw_seed_chorus, 2,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, chor_off, CreateTime(0,0),1.0); 
			s.AddRenderEvent(bw, bw_seed_chorus, 2,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, -1, CreateTime(0,0),1.0); 
			
			s.AddRenderEvent("Quick Intro Bass", intro_seed, 3,s.GetPartStartBar(i),s.GetPartStartBar(i)+1, -1, CreateTime(0,0),1.0); 
		}
		
		s.AddRenderEvent("Simple Chords", RndInt(0,32000), 2,s.GetPartEndBar(i)-1,s.GetPartEndBar(i), 0, CreateTime(0,0),0.8); 	
		
		if (i == s.GetParts()-1) 
		{
			s.AddRenderEvent("Simple Chords", RndInt(0,32000), 2,s.GetPartEndBar(i)-1,s.GetPartEndBar(i), 2, CreateTime(0,0),0.8); 	
			s.AddRenderEvent("Simple Chords Smooth", RndInt(0,32000), 2,s.GetPartEndBar(i)-1,s.GetPartEndBar(i), 3, CreateTime(0,s.GetUniquePart(s.GetPart(i).GetUniquePart()).GetMetrum()/2),0.8); 	
		}
		else
		{
			s.AddRenderEvent("Simple Chords", RndInt(0,32000), 2,s.GetPartEndBar(i)-1,s.GetPartEndBar(i), 1, CreateTime(0,s.GetUniquePart(s.GetPart(i).GetUniquePart()).GetMetrum()/2),0.75); 		
		}
	}
	
	return 1;	
}

void Arrange(Song @s)
{
	int style = RndInt(0,1);
	int slow;
		
	slow = ArrangeBoogieWoogie(s);
		
	if (slow > 0)
	{
		int bars = 0;
		for (int i = 0; i < s.GetParts(); i++)
		{
			double metrum = s.GetUniquePart(s.GetPart(i).GetUniquePart()).GetMetrum();
			bars += s.GetUniquePart(s.GetPart(i).GetUniquePart()).GetBars();
			
			if (i == s.GetParts()-1)
			{
				// zwolnienie na koniec
				s.AddTempoMod(CreateTime(bars-2, metrum/3), 0.95);
				s.AddTempoMod(CreateTime(bars-2, (metrum/3)*2), 0.90);
				s.AddTempoMod(CreateTime(bars-1, 0), 0.8);
			}
			else if (slow > 1)
			{
				// zwolnienie na koniec czesci
				s.AddTempoMod(CreateTime(bars-2, metrum/3), 0.95);
				s.AddTempoMod(CreateTime(bars-2, (metrum/3)*2), 0.90);
				s.AddTempoMod(CreateTime(bars-1, 0), 0.85);
				s.AddTempoMod(CreateTime(bars-1, metrum-1), 0.95);
			}
		}
	}
}